//-----------------------------------------------------------------------------
//  Galv's Bust Menu
//-----------------------------------------------------------------------------
//  For: RPGMAKER MV
//  GALV_BustMenu.js
//-----------------------------------------------------------------------------
//  2015-11-07 - Version 1.0 - release
//-----------------------------------------------------------------------------
// Terms can be found at:
// galvs-scripts.com
//-----------------------------------------------------------------------------

var Imported = Imported || {};
Imported.Galv_BustMenu = true;

var Galv = Galv || {};        // Galv's main object
Galv.BM = Galv.BM || {};      // Galv's stuff

//-----------------------------------------------------------------------------
/*:ja
 * @plugindesc メインメニューのレイアウトを変更し、アクターの表示数を行列とも指定し、併せて立ち絵を表示できます
 * @author Galv - galvs-scripts.com
 *
 * @param Menu Actors
 * @text アクター列数
 * @desc スクロールせずにメニューに表示されるアクターの列数(ゲーム内で変更可能)
 * @default 3
 *
 * @param Menu Actor Rows
 * @text アクター行数
 * @desc スクロールせずにメニューに表示されるアクターの行数(ゲーム内では変更できません)。立ち絵高設定を合わせて変更
 * @default 1
 *
 * @param Name
 * @text 名前
 * @desc アクターの名前の行順番
 * -1:表示しない
 * @default 1
 *
 * @param Nickname
 * @text 二つ名
 * @desc アクターの二つ名の行順番
 * -1:表示しない
 * @default 0
 *
 * @param Class
 * @text 職業
 * @desc アクターの職業の行順番
 * -1:表示しない
 * @default 2
 *
 * @param Level
 * @text レベル
 * @desc アクターのレベルの行順番
 * -1:表示しない
 * @default 3
 *
 * @param States
 * @text ステート
 * @desc アクターのステートアイコンの行順番
 * -1:表示しない
 * @default 13
 *
 * @param Bars
 * @text HP/MPバー
 * @desc アクターのHP/MPバーの行順番
 * -1:表示しない
 * @default 14
 *
 * @param Show Exp Bar
 * @text 経験値バー表示
 * @type boolean
 * @on 表示
 * @off 非表示
 * @desc 経験値バーを表示
 * 表示:true / 非表示:false
 * @default true
 *
 * @param Exp Bar
 * @text 経験値バー
 * @desc アクターの経験値バーの行順番
 * -1:表示しない
 * @default 4
 *
 * @param JP
 * @text JP
 * @desc アクターのJPの行順番(YEP_JobPoints使用時)
 * -1:表示しない
 * @default 2
 *
 * @param Exp Bar Height
 * @text 経験値バー高
 * @desc 経験値バーの高さ(ピクセル)
 * @default 10
 *
 * @param Show Exp Text
 * @text 経験値テキスト表示
 * @type boolean
 * @on 表示
 * @off 非表示
 * @desc バーに経験値テキストを表示
 * 表示:true / 非表示:false
 * @default true
 *
 * @param Exp Text
 * @text 経験値テキスト
 * @desc 経験値バーに表示されるテキスト
 * @default 次
 *
 * @param Max Exp Text
 * @text 最大経験値テキスト
 * @desc アクターが最大レベル時、経験値バーに表示されるテキスト
 * @default 最大
 *
 * @param Exp Bar Color 1
 * @text 経験値バーの色1
 * @desc 文字色番号で指定。色2とのグラデーション
 * @default 0
 *
 * @param Exp Bar Color 2
 * @text 経験値バーの色2
 * @desc 文字色番号で指定。色1とのグラデーション
 * @default 8
 *
 * @param Bust Y
 * @text 立ち絵Y位置
 * @desc 立ち絵のY位置(ピクセル単位)
 * @default 100
 *
 * @param Bust Height
 * @text 立ち絵高
 * @desc 立ち絵の高さ(ピクセル単位)
 * @default 360
 *
 * @param -----------
 * @text -----------
 * @desc
 *
 * @default
 *
 * @param Bust Offsets
 * @text 立ち絵オフセット
 * @desc 使用方法はヘルプ参照
 * @default
 *
 * @help
 * 翻訳:ムノクラ
 * https://fungamemake.com/
 * https://twitter.com/munokura/
 *
 * 元プラグイン:
 * https://galvs-scripts.com/2015/11/08/mv-bust-menu/
 *
 *   Galv's Bust Menu
 * ---------------------------------------------------------------------------
 * このプラグインは、メインメニューのアクターのレイアウトを変更します。
 * プラグインには、メニュー画面に表示されるアクターの数など、
 * アクターのデータの位置(名前、レベル、HP、画像など)を
 * 変更できる設定が含まれています。
 * 注:アクターが1人の場合、アクターの表示数の機能は働きません。
 *
 * プラグインは、
 * アクター顔画像に基づいて立ち絵(/img/pictures/内)を表示します。
 * 例:アクターが顔画像'Actor1'(/img/faces/内)の2番目の顔を使用する場合、
 * 立ち絵は代わりに立ち絵 Actor1_2.png (/img/pictures/内)を使用します。
 * ---------------------------------------------------------------------------
 *   立ち絵オフセット(プラグイン設定を下にスクロールしてこれを見つけます)
 * ---------------------------------------------------------------------------
 * 立ち絵はアクターの位置の中央に配置されますが、
 * 立ち絵は中央に配置されない場合があります。
 * この設定は、必要に応じて立ち絵のx、y位置を調整するために使用されます。
 * 立ち絵にx、yオフセットを追加するには、
 * 次のように設定にデータを追加します。
 *
 *     bustImageName_1,x,y|bustImageName_2,x,y|bustImageName_3,x,y
 *
 * 各画像とデータはパイプ('|'記号)で区切られます。
 * 例
 * Actor1_2,-10,0|Actor1_5,20,5
 * 立ち絵 Actor1_2.png は、10ピクセル左にオフセットされます
 * 立ち絵 Actor1_5.png は、20ピクセル右に、5ピクセル下にオフセットされます
 * ---------------------------------------------------------------------------
 *   スクリプトコール
 * ---------------------------------------------------------------------------
 * $gameParty._bustActorCount = x;        // x:表示するアクターの番号
 * ---------------------------------------------------------------------------
 */


//-----------------------------------------------------------------------------
//  CODE STUFFS
//-----------------------------------------------------------------------------

(function() {	

Galv.BM.a = Number(PluginManager.parameters('Galv_BustMenu')["Menu Actors"]);
Galv.BM.name = Number(PluginManager.parameters('Galv_BustMenu')["Name"] - 1);
Galv.BM.class = Number(PluginManager.parameters('Galv_BustMenu')["Class"] - 1);
Galv.BM.level = Number(PluginManager.parameters('Galv_BustMenu')["Level"] - 1);
Galv.BM.bars = Number(PluginManager.parameters('Galv_BustMenu')["Bars"] - 1);
Galv.BM.icons = Number(PluginManager.parameters('Galv_BustMenu')["States"] - 1);
Galv.BM.bust = Number(PluginManager.parameters('Galv_BustMenu')["Bust Y"]);
Galv.BM.bustHeight = Number(PluginManager.parameters('Galv_BustMenu')["Bust Height"]);
/*↓add start 2017/6/17↓*/
Galv.BM.MpDrawFlg = Number(PluginManager.parameters('Galv_BustMenu')["MpDrawFlg"]);
Galv.BM.TpDrawFlg = Number(PluginManager.parameters('Galv_BustMenu')["TpDrawFlg"]);
/*↓add start 2019/4/18↓*/
Galv.BM.hpDrawFlg = Number(PluginManager.parameters('Galv_BustMenu')["hpDrawFlg"]);
/*↓add start 2019/4/22↓*/
Galv.BM.hpPeternNo = Number(PluginManager.parameters('Galv_BustMenu')["hpGagePatern"]);

Galv.BM.offsets = function() {
	var array = PluginManager.parameters('Galv_BustMenu')["Bust Offsets"].split("|");
	var obj = {};
	for (i = 0; i < array.length; i++) {
		if (array[i]) {
			var data = array[i].split(",");
			obj[data[0]] = [Number(data[1]),Number(data[2])];
		};
	};
	return obj;
}();


// OVERWRITE
Window_MenuStatus.prototype.numVisibleRows = function() {
    return 1;
};
Window_MenuStatus.prototype.maxCols = function() {
    return Galv.BM.a;
};
Window_Selectable.prototype.spacing = function() {
    return 0;
};

Window_MenuStatus.prototype.drawItemStatus = function(index) {
    var actor = $gameParty.members()[index];
    var rect = this.itemRect(index);
    var x = rect.x;
    var y = rect.y;
    var width = rect.width - x - this.textPadding();
    this.drawActorSimpleStatus(actor, x, y, width);
};


// OVERWRITE
Window_MenuStatus.prototype.drawActorSimpleStatus = function(actor, x, y, width) {
    var lineHeight = this.lineHeight();
	var width = this.bustWidth();
	var x = x + 5;
    var width2 = Math.max(100, width - this.textPadding());
    this.drawActorName(actor, x, y + lineHeight * Galv.BM.name);
    //this.drawActorLevel(actor, x, y + lineHeight * Galv.BM.level);
    this.drawActorIcons(actor, x, y + lineHeight * Galv.BM.icons );
    this.drawActorClass(actor, x, y + lineHeight * Galv.BM.class, width2);
    if(Galv.BM.hpDrawFlg === 1)	
    {
    	if( Galv.BM.hpPeternNo === 0)
			this.drawActorHp(actor, x, y + lineHeight * (Galv.BM.bars + 1 ), width2);//add 2019/4/18
			
		else
			this.drawActorHeart(actor, x, y + lineHeight * (Galv.BM.bars + 1 ), width2);//add 2019/4/22
	}
		
    if(Galv.BM.MpDrawFlg === 1)													//add 2017/6/17
    	this.drawActorMp(actor, x, y + lineHeight * (Galv.BM.bars + 2), width2);
    
    if(Galv.BM.TpDrawFlg === 1)													//add 2017/6/17
    {
		if (Imported.YEP_CoreEngine && eval(Yanfly.Param.MenuTpGauge)) {
			this.drawActorTp(actor, x, y + lineHeight * (Galv.BM.bars + 2), width2);
		}
	}
	
};


Window_MenuStatus.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
    var width = this.bustWidth();

	var bustName = faceName + "_" + (faceIndex + 1)
	var bitmap = ImageManager.loadPicture(bustName);
	var ox = 0;
	var oy = 0;
	if (Galv.BM.offsets[bustName]) {
		ox = Galv.BM.offsets[bustName][0] || 0;
		oy = Galv.BM.offsets[bustName][1] || 0;
	};
	
    var sw = width;
    var sh = Galv.BM.bustHeight;
    var dx = x - 1;
    var dy = y + Galv.BM.bust;
    var sx = bitmap.width / 2 - width / 2 - ox;
    var sy = oy;
    this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy);
};

Window_MenuStatus.prototype.bustWidth = function() {
    return Math.floor((this.width - (this.standardPadding() * 2)) / this.maxCols());
};


Window_MenuStatus.prototype.cursorDown = function(wrap) {
    var index = this.index();
    var maxItems = this.maxItems();
    var maxCols = this.maxCols();
    if (index < maxItems - maxCols || (wrap && maxCols === 1)) {
        this.select((index + maxCols) % maxItems);
	} else {
		this.select(maxItems - 1);
    }
};


Window_MenuStatus.prototype.cursorUp = function(wrap) {
    var index = this.index();
    var maxItems = this.maxItems();
    var maxCols = this.maxCols();
    if (index >= maxCols || (wrap && maxCols === 1)) {
        this.select((index - maxCols + maxItems) % maxItems);
	} else {
		this.select(0);
    }
};

/**
 * hpHeart
 */
Window_MenuStatus.prototype.drawActorHeart = function(actor, x, y, width)
{
	this.drawHeart(actor, x, y);
}

/**
 * drawHeart
 */
Window_MenuStatus.prototype.drawHeart = function(actor, x, y)
{
	var varHertCnt = actor.mhp / 100;
	var varHp = actor.hp;
	var varLoadHertName = "ハート_0";
	
	var ans = varHp;
	
	//先行ロード
	for(i = 0; i < 5; i++)
	{
		var bitmap = ImageManager.loadSystem( "ハート_" + i);
		this.contents.blt( bitmap, 0, 0, 24, 20, x, y );
	}
	
	var bitmap = ImageManager.loadSystem( "ハート_0");
	this.contents.blt( bitmap, 0, 0, 24, 20, x, y );
	
	for(var i = 0; i < varHertCnt; i++)
	{
		//75以上はハート満タン
		if(ans >= 75)
		{
			varLoadHertName = "ハート_4";
			//alert("減ってない");
		}
		//50以上はハート3/4
		else if( ans >= 50) 
		{
			varLoadHertName = "ハート_3";
			//alert("3/4");
		}
		//25以上は2/4
		else if(ans >= 25)
		{
			varLoadHertName = "ハート_2";
			//alert("2/4");
		}
		//0以上は1/4
		else if(ans > 0)
		{
			varLoadHertName = "ハート_1";
			//alert("1/4");
		}
		
		//0未満の時は空
		else
		{
			varLoadHertName = "ハート_0";
			//alert("0/4");
		}
		
		var bitmap = ImageManager.loadSystem( varLoadHertName );
		//this.contents.blt( bitmap, 0, 0, 24, 20, 14 + 24 * i, 30 );
		this.contents.blt( bitmap, 0, 0, 24, 20, x + (24 * i), y );
		ans -= 100;						//100づつ減らしていく
	}
}

})();